from flask import Flask, render_template
from flask_socketio import SocketIO, emit
import os

app = Flask(__name__)
app.config['SECRET_KEY'] = os.environ.get('SECRET_KEY')
socketio = SocketIO(app)


@app.route('/')
def index():
    return render_template('index.html')


@socketio.on('toggle_image')
def handle_toggle_image(data):
    emit('image_toggled', data, broadcast=True)


@socketio.on('chat_message')
def handle_chat_message(message):
    emit('chat_message', message, broadcast=True)


if __name__ == '__main__':
    socketio.run(app, debug=True)
